@extends('layouts.guest')
@section('content')
<div class="login-box">
	<div class="cf-login">
		<div class="cf-form ">
			<div class="form-wrapper w-100">
				@foreach ($errors->all() as $message)
				<div class="alert alert-danger" role="alert">{{ $message }}</div>
				@endforeach

				@if(Session::has('error'))
				<div class="alert alert-danger" role="alert">{{ session('error') }}</div>
				@endif
				<form method="POST" id="js-login-form" class="" action="{{ route('login') }}">
					@csrf
					<h2 class="text-dark">{{ get_option('brand_name') }}</h2>
					<div class="form-group my-4 ">
						<div class="input-group ">
							<input type="email" class="form-control " name="email" placeholder="{{ __('login.ph_email') }}">
							<div class="input-group-append"> 
								<div class="input-group-text">
									<span class="fas fa-envelope"></span>
								</div>
							</div>
						</div>
					</div>
					<div class="form-group my-4">
						<div class="input-group">
							<input type="password" name="password" class="form-control" placeholder="{{ __('login.ph_password') }}">
							<div class="input-group-append">
								<div class="input-group-text">
									<span class="fas fa-lock"></span>
								</div>
							</div>
						</div>
					</div>
					<div class="icheck-primary my-4">
						<input type="checkbox" id="remember" name="remember">
						<label for="remember" class="text-dark">
							{{ __('login.remember_me') }}
						</label>
					</div>
					<button type="submit" class="btn btn-primary   px-4">{{ __('login.login') }}</button>
				</form>
			</div>
		</div>
		<div class="cf-login-image " style="background-image: url('{{ logo_url('login_image') }}');"></div>
	</div>
</div>
@stop

@section('styles')
<!--  PAGE SPECIFIC STYLES -->
<link href="{{ asset('assets/css/login.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('js-script')
<!-- JQUERY-VALIDATION -->
<script src="{{ asset('plugins/jquery-validation/jquery.validate.min.js') }}"></script>
<script src="{{ asset('plugins/jquery-validation/additional-methods.min.js') }}"></script>
<script src="{{ asset('assets/form-validation-rules/login-form.js') }}"></script>
@endsection